package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsEventSubscriptionDetails(
    custSubscriptionId: Optional[NonEmptyString] = Optional.Absent,
    customerAwsId: Optional[NonEmptyString] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    eventCategoriesList: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    eventSubscriptionArn: Optional[NonEmptyString] = Optional.Absent,
    snsTopicArn: Optional[NonEmptyString] = Optional.Absent,
    sourceIdsList: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    sourceType: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    subscriptionCreationTime: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails = {
    import AwsRdsEventSubscriptionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
      .builder()
      .optionallyWith(
        custSubscriptionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.custSubscriptionId)
      .optionallyWith(
        customerAwsId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customerAwsId)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(
        eventSubscriptionArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.eventSubscriptionArn)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        sourceType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subscriptionCreationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails
      .wrap(buildAwsValue())
}
object AwsRdsEventSubscriptionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails =
      zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails(
        custSubscriptionId.map(value => value),
        customerAwsId.map(value => value),
        enabled.map(value => value),
        eventCategoriesList.map(value => value),
        eventSubscriptionArn.map(value => value),
        snsTopicArn.map(value => value),
        sourceIdsList.map(value => value),
        sourceType.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value)
      )
    def custSubscriptionId: Optional[NonEmptyString]
    def customerAwsId: Optional[NonEmptyString]
    def enabled: Optional[Boolean]
    def eventCategoriesList: Optional[List[NonEmptyString]]
    def eventSubscriptionArn: Optional[NonEmptyString]
    def snsTopicArn: Optional[NonEmptyString]
    def sourceIdsList: Optional[List[NonEmptyString]]
    def sourceType: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def subscriptionCreationTime: Optional[NonEmptyString]
    def getCustSubscriptionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getCustomerAwsId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEventCategoriesList: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getEventSubscriptionArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("eventSubscriptionArn", eventSubscriptionArn)
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSourceIdsList: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getSourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "subscriptionCreationTime",
        subscriptionCreationTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
  ) extends zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly {
    override val custSubscriptionId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.custSubscriptionId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val customerAwsId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.customerAwsId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val eventCategoriesList: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCategoriesList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val eventSubscriptionArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscriptionArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val snsTopicArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceIdsList: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIdsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val sourceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subscriptionCreationTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionCreationTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
  ): zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly =
    new Wrapper(impl)
}
