package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute(
    attributeName: Optional[NonEmptyString] = Optional.Absent,
    attributeValues: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute = {
    import AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
      .wrap(buildAwsValue())
}
object AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute =
      zio.aws.securityhub.model
        .AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute(
          attributeName.map(value => value),
          attributeValues.map(value => value)
        )
    def attributeName: Optional[NonEmptyString]
    def attributeValues: Optional[List[NonEmptyString]]
    def getAttributeName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.ReadOnly {
    override val attributeName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val attributeValues: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
  ): zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.ReadOnly =
    new Wrapper(impl)
}
