package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails(
    enabled: Optional[Boolean] = Optional.Absent,
    internalUserDatabaseEnabled: Optional[Boolean] = Optional.Absent,
    masterUserOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails = {
    import AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        internalUserDatabaseEnabled.map(value => value: java.lang.Boolean)
      )(_.internalUserDatabaseEnabled)
      .optionallyWith(masterUserOptions.map(value => value.buildAwsValue()))(
        _.masterUserOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails(
          enabled.map(value => value),
          internalUserDatabaseEnabled.map(value => value),
          masterUserOptions.map(value => value.asEditable)
        )
    def enabled: Optional[Boolean]
    def internalUserDatabaseEnabled: Optional[Boolean]
    def masterUserOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails.ReadOnly
    ]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getInternalUserDatabaseEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "internalUserDatabaseEnabled",
        internalUserDatabaseEnabled
      )
    def getMasterUserOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("masterUserOptions", masterUserOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val internalUserDatabaseEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internalUserDatabaseEnabled())
        .map(value => value: Boolean)
    override val masterUserOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
