package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterDetails(
    clusterInfo: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterDetails = {
    import AwsMskClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterDetails
      .builder()
      .optionallyWith(clusterInfo.map(value => value.buildAwsValue()))(
        _.clusterInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsMskClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterDetails.wrap(buildAwsValue())
}
object AwsMskClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsMskClusterDetails =
      zio.aws.securityhub.model
        .AwsMskClusterDetails(clusterInfo.map(value => value.asEditable))
    def clusterInfo: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.ReadOnly
    ]
    def getClusterInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.ReadOnly
    ] = AwsError.unwrapOptionField("clusterInfo", clusterInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterDetails.ReadOnly {
    override val clusterInfo: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterDetails
  ): zio.aws.securityhub.model.AwsMskClusterDetails.ReadOnly = new Wrapper(impl)
}
