package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails(
    inCluster: Optional[Boolean] = Optional.Absent,
    clientBroker: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails = {
    import AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
      .builder()
      .optionallyWith(inCluster.map(value => value: java.lang.Boolean))(
        _.inCluster
      )
      .optionallyWith(
        clientBroker.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clientBroker)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails(
          inCluster.map(value => value),
          clientBroker.map(value => value)
        )
    def inCluster: Optional[Boolean]
    def clientBroker: Optional[NonEmptyString]
    def getInCluster: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("inCluster", inCluster)
    def getClientBroker: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientBroker", clientBroker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.ReadOnly {
    override val inCluster: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inCluster())
      .map(value => value: Boolean)
    override val clientBroker: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientBroker())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.ReadOnly =
    new Wrapper(impl)
}
