package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails(
    dataVolumeKMSKeyId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails = {
    import AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
      .builder()
      .optionallyWith(
        dataVolumeKMSKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dataVolumeKMSKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails(
          dataVolumeKMSKeyId.map(value => value)
        )
    def dataVolumeKMSKeyId: Optional[NonEmptyString]
    def getDataVolumeKMSKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dataVolumeKMSKeyId", dataVolumeKMSKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.ReadOnly {
    override val dataVolumeKMSKeyId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataVolumeKMSKeyId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.ReadOnly =
    new Wrapper(impl)
}
