package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoEncryptionInfoDetails(
    encryptionInTransit: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
    ] = Optional.Absent,
    encryptionAtRest: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails = {
    import AwsMskClusterClusterInfoEncryptionInfoDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
      .builder()
      .optionallyWith(encryptionInTransit.map(value => value.buildAwsValue()))(
        _.encryptionInTransit
      )
      .optionallyWith(encryptionAtRest.map(value => value.buildAwsValue()))(
        _.encryptionAtRest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoEncryptionInfoDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails =
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails(
        encryptionInTransit.map(value => value.asEditable),
        encryptionAtRest.map(value => value.asEditable)
      )
    def encryptionInTransit: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.ReadOnly
    ]
    def encryptionAtRest: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.ReadOnly
    ]
    def getEncryptionInTransit: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionInTransit", encryptionInTransit)
    def getEncryptionAtRest: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionAtRest", encryptionAtRest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails.ReadOnly {
    override val encryptionInTransit: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionInTransit())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails
          .wrap(value)
      )
    override val encryptionAtRest: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAtRest())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoEncryptionInfoDetails.ReadOnly =
    new Wrapper(impl)
}
