package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails = {
    import AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails(
          enabled.map(value => value)
        )
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.ReadOnly =
    new Wrapper(impl)
}
