package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoClientAuthenticationTlsDetails(
    certificateAuthorityArnList: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails = {
    import AwsMskClusterClusterInfoClientAuthenticationTlsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
      .builder()
      .optionallyWith(
        certificateAuthorityArnList.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAuthorityArnList)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoClientAuthenticationTlsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoClientAuthenticationTlsDetails(
          certificateAuthorityArnList.map(value => value),
          enabled.map(value => value)
        )
    def certificateAuthorityArnList: Optional[List[NonEmptyString]]
    def enabled: Optional[Boolean]
    def getCertificateAuthorityArnList
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "certificateAuthorityArnList",
      certificateAuthorityArnList
    )
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails.ReadOnly {
    override val certificateAuthorityArnList: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityArnList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails.ReadOnly =
    new Wrapper(impl)
}
