package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsMskClusterClusterInfoClientAuthenticationDetails(
    sasl: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
    ] = Optional.Absent,
    unauthenticated: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
    ] = Optional.Absent,
    tls: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails = {
    import AwsMskClusterClusterInfoClientAuthenticationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
      .builder()
      .optionallyWith(sasl.map(value => value.buildAwsValue()))(_.sasl)
      .optionallyWith(unauthenticated.map(value => value.buildAwsValue()))(
        _.unauthenticated
      )
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
      .wrap(buildAwsValue())
}
object AwsMskClusterClusterInfoClientAuthenticationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails =
      zio.aws.securityhub.model
        .AwsMskClusterClusterInfoClientAuthenticationDetails(
          sasl.map(value => value.asEditable),
          unauthenticated.map(value => value.asEditable),
          tls.map(value => value.asEditable)
        )
    def sasl: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails.ReadOnly
    ]
    def unauthenticated: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.ReadOnly
    ]
    def tls: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails.ReadOnly
    ]
    def getSasl: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sasl", sasl)
    def getUnauthenticated: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.ReadOnly
    ] = AwsError.unwrapOptionField("unauthenticated", unauthenticated)
    def getTls: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
  ) extends zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails.ReadOnly {
    override val sasl: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sasl())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationSaslDetails
          .wrap(value)
      )
    override val unauthenticated: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unauthenticated())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails
          .wrap(value)
      )
    override val tls: Optional[
      zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tls())
      .map(value =>
        zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationTlsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails
  ): zio.aws.securityhub.model.AwsMskClusterClusterInfoClientAuthenticationDetails.ReadOnly =
    new Wrapper(impl)
}
