package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionEnvironmentError(
    errorCode: Optional[NonEmptyString] = Optional.Absent,
    message: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironmentError = {
    import AwsLambdaFunctionEnvironmentError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironmentError
      .builder()
      .optionallyWith(
        errorCode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        message.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError
      .wrap(buildAwsValue())
}
object AwsLambdaFunctionEnvironmentError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironmentError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError =
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError(
        errorCode.map(value => value),
        message.map(value => value)
      )
    def errorCode: Optional[NonEmptyString]
    def message: Optional[NonEmptyString]
    def getErrorCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironmentError
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly {
    override val errorCode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val message: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironmentError
  ): zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly =
    new Wrapper(impl)
}
