package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamUserPolicy(
    policyName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy = {
    import AwsIamUserPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsIamUserPolicy.wrap(buildAwsValue())
}
object AwsIamUserPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamUserPolicy =
      zio.aws.securityhub.model.AwsIamUserPolicy(policyName.map(value => value))
    def policyName: Optional[NonEmptyString]
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
  ) extends zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly {
    override val policyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
  ): zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly = new Wrapper(impl)
}
