package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  Integer,
  NonEmptyString,
  AwsIamRoleAssumeRolePolicyDocument
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamRoleDetails(
    assumeRolePolicyDocument: Optional[AwsIamRoleAssumeRolePolicyDocument] =
      Optional.Absent,
    attachedManagedPolicies: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy]
    ] = Optional.Absent,
    createDate: Optional[NonEmptyString] = Optional.Absent,
    instanceProfileList: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamInstanceProfile]
    ] = Optional.Absent,
    permissionsBoundary: Optional[
      zio.aws.securityhub.model.AwsIamPermissionsBoundary
    ] = Optional.Absent,
    roleId: Optional[NonEmptyString] = Optional.Absent,
    roleName: Optional[NonEmptyString] = Optional.Absent,
    rolePolicyList: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamRolePolicy]
    ] = Optional.Absent,
    maxSessionDuration: Optional[Integer] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails = {
    import AwsIamRoleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
      .builder()
      .optionallyWith(
        assumeRolePolicyDocument.map(value =>
          AwsIamRoleAssumeRolePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.assumeRolePolicyDocument)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        instanceProfileList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceProfileList)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        roleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleId)
      .optionallyWith(
        roleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        rolePolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rolePolicyList)
      .optionallyWith(
        maxSessionDuration.map(value => value: java.lang.Integer)
      )(_.maxSessionDuration)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamRoleDetails.wrap(buildAwsValue())
}
object AwsIamRoleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamRoleDetails =
      zio.aws.securityhub.model.AwsIamRoleDetails(
        assumeRolePolicyDocument.map(value => value),
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDate.map(value => value),
        instanceProfileList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        permissionsBoundary.map(value => value.asEditable),
        roleId.map(value => value),
        roleName.map(value => value),
        rolePolicyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxSessionDuration.map(value => value),
        path.map(value => value)
      )
    def assumeRolePolicyDocument: Optional[AwsIamRoleAssumeRolePolicyDocument]
    def attachedManagedPolicies: Optional[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ]
    def createDate: Optional[NonEmptyString]
    def instanceProfileList: Optional[
      List[zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly]
    ]
    def permissionsBoundary
        : Optional[zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly]
    def roleId: Optional[NonEmptyString]
    def roleName: Optional[NonEmptyString]
    def rolePolicyList
        : Optional[List[zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly]]
    def maxSessionDuration: Optional[Integer]
    def path: Optional[NonEmptyString]
    def getAssumeRolePolicyDocument
        : ZIO[Any, AwsError, AwsIamRoleAssumeRolePolicyDocument] = AwsError
      .unwrapOptionField("assumeRolePolicyDocument", assumeRolePolicyDocument)
    def getAttachedManagedPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachedManagedPolicies",
      attachedManagedPolicies
    )
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getInstanceProfileList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceProfileList", instanceProfileList)
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getRoleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleId", roleId)
    def getRoleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getRolePolicyList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("rolePolicyList", rolePolicyList)
    def getMaxSessionDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
  ) extends zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly {
    override val assumeRolePolicyDocument
        : Optional[AwsIamRoleAssumeRolePolicyDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.assumeRolePolicyDocument())
      .map(value =>
        zio.aws.securityhub.model.primitives
          .AwsIamRoleAssumeRolePolicyDocument(value)
      )
    override val attachedManagedPolicies: Optional[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.wrap(item)
        }.toList
      )
    override val createDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceProfileList: Optional[
      List[zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfileList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamInstanceProfile.wrap(item)
        }.toList
      )
    override val permissionsBoundary: Optional[
      zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionsBoundary())
      .map(value =>
        zio.aws.securityhub.model.AwsIamPermissionsBoundary.wrap(value)
      )
    override val roleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rolePolicyList
        : Optional[List[zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rolePolicyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsIamRolePolicy.wrap(item)
          }.toList
        )
    override val maxSessionDuration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSessionDuration())
      .map(value => value: Integer)
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
  ): zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly = new Wrapper(impl)
}
