package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGuardDutyDetectorDetails(
    dataSources: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
    ] = Optional.Absent,
    features: Optional[
      Iterable[zio.aws.securityhub.model.AwsGuardDutyDetectorFeaturesDetails]
    ] = Optional.Absent,
    findingPublishingFrequency: Optional[NonEmptyString] = Optional.Absent,
    serviceRole: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDetails = {
    import AwsGuardDutyDetectorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDetails
      .builder()
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .optionallyWith(
        features.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.features)
      .optionallyWith(
        findingPublishingFrequency.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.findingPublishingFrequency)
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsGuardDutyDetectorDetails.ReadOnly =
    zio.aws.securityhub.model.AwsGuardDutyDetectorDetails.wrap(buildAwsValue())
}
object AwsGuardDutyDetectorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsGuardDutyDetectorDetails =
      zio.aws.securityhub.model.AwsGuardDutyDetectorDetails(
        dataSources.map(value => value.asEditable),
        features.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingPublishingFrequency.map(value => value),
        serviceRole.map(value => value),
        status.map(value => value)
      )
    def dataSources: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails.ReadOnly
    ]
    def features: Optional[List[
      zio.aws.securityhub.model.AwsGuardDutyDetectorFeaturesDetails.ReadOnly
    ]]
    def findingPublishingFrequency: Optional[NonEmptyString]
    def serviceRole: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsGuardDutyDetectorFeaturesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("features", features)
    def getFindingPublishingFrequency: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "findingPublishingFrequency",
        findingPublishingFrequency
      )
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDetails
  ) extends zio.aws.securityhub.model.AwsGuardDutyDetectorDetails.ReadOnly {
    override val dataSources: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSources())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails
          .wrap(value)
      )
    override val features: Optional[List[
      zio.aws.securityhub.model.AwsGuardDutyDetectorFeaturesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.features())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsGuardDutyDetectorFeaturesDetails
            .wrap(item)
        }.toList
      )
    override val findingPublishingFrequency: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingPublishingFrequency())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDetails
  ): zio.aws.securityhub.model.AwsGuardDutyDetectorDetails.ReadOnly =
    new Wrapper(impl)
}
