package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGuardDutyDetectorDataSourcesKubernetesDetails(
    auditLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails = {
    import AwsGuardDutyDetectorDataSourcesKubernetesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
      .builder()
      .optionallyWith(auditLogs.map(value => value.buildAwsValue()))(
        _.auditLogs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
      .wrap(buildAwsValue())
}
object AwsGuardDutyDetectorDataSourcesKubernetesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails =
      zio.aws.securityhub.model
        .AwsGuardDutyDetectorDataSourcesKubernetesDetails(
          auditLogs.map(value => value.asEditable)
        )
    def auditLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails.ReadOnly
    ]
    def getAuditLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("auditLogs", auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
  ) extends zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails.ReadOnly {
    override val auditLogs: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.auditLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails
  ): zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesKubernetesDetails.ReadOnly =
    new Wrapper(impl)
}
