package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails(
    healthCheck: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails = {
    import AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
      .builder()
      .optionallyWith(
        healthCheck.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.healthCheck)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
      .wrap(buildAwsValue())
}
object AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails =
      zio.aws.securityhub.model
        .AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails(
          healthCheck.map(value => value)
        )
    def healthCheck: Optional[NonEmptyString]
    def getHealthCheck: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("healthCheck", healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.ReadOnly {
    override val healthCheck: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheck())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.ReadOnly =
    new Wrapper(impl)
}
