package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointRoutingConfigDetails(
    failoverConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigDetails = {
    import AwsEventsEndpointRoutingConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigDetails
      .builder()
      .optionallyWith(failoverConfig.map(value => value.buildAwsValue()))(
        _.failoverConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails
      .wrap(buildAwsValue())
}
object AwsEventsEndpointRoutingConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails =
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails(
        failoverConfig.map(value => value.asEditable)
      )
    def failoverConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails.ReadOnly
    ]
    def getFailoverConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failoverConfig", failoverConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails.ReadOnly {
    override val failoverConfig: Optional[
      zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failoverConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigFailoverConfigDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointRoutingConfigDetails.ReadOnly =
    new Wrapper(impl)
}
