package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventsEndpointReplicationConfigDetails(
    state: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointReplicationConfigDetails = {
    import AwsEventsEndpointReplicationConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointReplicationConfigDetails
      .builder()
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails
      .wrap(buildAwsValue())
}
object AwsEventsEndpointReplicationConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointReplicationConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails =
      zio.aws.securityhub.model
        .AwsEventsEndpointReplicationConfigDetails(state.map(value => value))
    def state: Optional[NonEmptyString]
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointReplicationConfigDetails
  ) extends zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails.ReadOnly {
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointReplicationConfigDetails
  ): zio.aws.securityhub.model.AwsEventsEndpointReplicationConfigDetails.ReadOnly =
    new Wrapper(impl)
}
