package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLbCookieStickinessPolicy(
    cookieExpirationPeriod: Optional[Long] = Optional.Absent,
    policyName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy = {
    import AwsElbLbCookieStickinessPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
      .builder()
      .optionallyWith(
        cookieExpirationPeriod.map(value => value: java.lang.Long)
      )(_.cookieExpirationPeriod)
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy
      .wrap(buildAwsValue())
}
object AwsElbLbCookieStickinessPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy =
      zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy(
        cookieExpirationPeriod.map(value => value),
        policyName.map(value => value)
      )
    def cookieExpirationPeriod: Optional[Long]
    def policyName: Optional[NonEmptyString]
    def getCookieExpirationPeriod: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("cookieExpirationPeriod", cookieExpirationPeriod)
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
  ) extends zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly {
    override val cookieExpirationPeriod: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.cookieExpirationPeriod())
      .map(value => value: Long)
    override val policyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
  ): zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly =
    new Wrapper(impl)
}
