package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionDetails(
    containerDefinitions: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
    ]] = Optional.Absent,
    cpu: Optional[NonEmptyString] = Optional.Absent,
    executionRoleArn: Optional[NonEmptyString] = Optional.Absent,
    family: Optional[NonEmptyString] = Optional.Absent,
    inferenceAccelerators: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
    ]] = Optional.Absent,
    ipcMode: Optional[NonEmptyString] = Optional.Absent,
    memory: Optional[NonEmptyString] = Optional.Absent,
    networkMode: Optional[NonEmptyString] = Optional.Absent,
    pidMode: Optional[NonEmptyString] = Optional.Absent,
    placementConstraints: Optional[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
    ]] = Optional.Absent,
    proxyConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
    ] = Optional.Absent,
    requiresCompatibilities: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    taskRoleArn: Optional[NonEmptyString] = Optional.Absent,
    volumes: Optional[
      Iterable[zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails]
    ] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails = {
    import AwsEcsTaskDefinitionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
      .builder()
      .optionallyWith(
        containerDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerDefinitions)
      .optionallyWith(
        cpu.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cpu)
      .optionallyWith(
        executionRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(
        family.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.family)
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(
        ipcMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipcMode)
      .optionallyWith(
        memory.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.memory)
      .optionallyWith(
        networkMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.networkMode)
      .optionallyWith(
        pidMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.pidMode)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        requiresCompatibilities.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiresCompatibilities)
      .optionallyWith(
        taskRoleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.taskRoleArn)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails(
        containerDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cpu.map(value => value),
        executionRoleArn.map(value => value),
        family.map(value => value),
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipcMode.map(value => value),
        memory.map(value => value),
        networkMode.map(value => value),
        pidMode.map(value => value),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        proxyConfiguration.map(value => value.asEditable),
        requiresCompatibilities.map(value => value),
        taskRoleArn.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def containerDefinitions: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly
    ]]
    def cpu: Optional[NonEmptyString]
    def executionRoleArn: Optional[NonEmptyString]
    def family: Optional[NonEmptyString]
    def inferenceAccelerators: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly
    ]]
    def ipcMode: Optional[NonEmptyString]
    def memory: Optional[NonEmptyString]
    def networkMode: Optional[NonEmptyString]
    def pidMode: Optional[NonEmptyString]
    def placementConstraints: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly
    ]]
    def proxyConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly
    ]
    def requiresCompatibilities: Optional[List[NonEmptyString]]
    def taskRoleArn: Optional[NonEmptyString]
    def volumes: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly
    ]]
    def status: Optional[NonEmptyString]
    def getContainerDefinitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("containerDefinitions", containerDefinitions)
    def getCpu: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getExecutionRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getFamily: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("family", family)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getIpcMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipcMode", ipcMode)
    def getMemory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memory", memory)
    def getNetworkMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkMode", networkMode)
    def getPidMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("pidMode", pidMode)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getProxyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getRequiresCompatibilities: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "requiresCompatibilities",
        requiresCompatibilities
      )
    def getTaskRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getVolumes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("volumes", volumes)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly {
    override val containerDefinitions: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.containerDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
            .wrap(item)
        }.toList
      )
    override val cpu: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val executionRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val family: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.family())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val inferenceAccelerators: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
            .wrap(item)
        }.toList
      )
    override val ipcMode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipcMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val memory: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkMode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.networkMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val pidMode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.pidMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val placementConstraints: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
            .wrap(item)
        }.toList
      )
    override val proxyConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proxyConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
          .wrap(value)
      )
    override val requiresCompatibilities: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiresCompatibilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val taskRoleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumes: Optional[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
            .wrap(item)
        }.toList
      )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly =
    new Wrapper(impl)
}
