package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupIpv6Range(
    cidrIpv6: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6Range = {
    import AwsEc2SecurityGroupIpv6Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6Range
      .builder()
      .optionallyWith(
        cidrIpv6.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrIpv6)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.wrap(buildAwsValue())
}
object AwsEc2SecurityGroupIpv6Range {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6Range
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range =
      zio.aws.securityhub.model
        .AwsEc2SecurityGroupIpv6Range(cidrIpv6.map(value => value))
    def cidrIpv6: Optional[NonEmptyString]
    def getCidrIpv6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrIpv6", cidrIpv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6Range
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly {
    override val cidrIpv6: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIpv6())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpv6Range
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly =
    new Wrapper(impl)
}
