package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails(
    enableResourceNameDnsAAAARecord: Optional[Boolean] = Optional.Absent,
    enableResourceNameDnsARecord: Optional[Boolean] = Optional.Absent,
    hostnameType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails = {
    import AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
      .builder()
      .optionallyWith(
        enableResourceNameDnsAAAARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsAAAARecord)
      .optionallyWith(
        enableResourceNameDnsARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsARecord)
      .optionallyWith(
        hostnameType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostnameType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails(
          enableResourceNameDnsAAAARecord.map(value => value),
          enableResourceNameDnsARecord.map(value => value),
          hostnameType.map(value => value)
        )
    def enableResourceNameDnsAAAARecord: Optional[Boolean]
    def enableResourceNameDnsARecord: Optional[Boolean]
    def hostnameType: Optional[NonEmptyString]
    def getEnableResourceNameDnsAAAARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecord",
        enableResourceNameDnsAAAARecord
      )
    def getEnableResourceNameDnsARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecord",
        enableResourceNameDnsARecord
      )
    def getHostnameType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostnameType", hostnameType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.ReadOnly {
    override val enableResourceNameDnsAAAARecord: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsAAAARecord())
        .map(value => value: Boolean)
    override val enableResourceNameDnsARecord: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsARecord())
        .map(value => value: Boolean)
    override val hostnameType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostnameType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
