package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails(
    primary: Optional[Boolean] = Optional.Absent,
    privateIpAddress: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails = {
    import AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
      .builder()
      .optionallyWith(primary.map(value => value: java.lang.Boolean))(_.primary)
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails(
          primary.map(value => value),
          privateIpAddress.map(value => value)
        )
    def primary: Optional[Boolean]
    def privateIpAddress: Optional[NonEmptyString]
    def getPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("primary", primary)
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.ReadOnly {
    override val primary: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.primary())
      .map(value => value: Boolean)
    override val privateIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.ReadOnly =
    new Wrapper(impl)
}
