package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails(
    ipv6Address: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails = {
    import AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
      .builder()
      .optionallyWith(
        ipv6Address.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipv6Address)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails(
          ipv6Address.map(value => value)
        )
    def ipv6Address: Optional[NonEmptyString]
    def getIpv6Address: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.ReadOnly {
    override val ipv6Address: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Address())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.ReadOnly =
    new Wrapper(impl)
}
