package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2InstanceMonitoringDetails(
    state: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMonitoringDetails = {
    import AwsEc2InstanceMonitoringDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMonitoringDetails
      .builder()
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails
      .wrap(buildAwsValue())
}
object AwsEc2InstanceMonitoringDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMonitoringDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails =
      zio.aws.securityhub.model
        .AwsEc2InstanceMonitoringDetails(state.map(value => value))
    def state: Optional[NonEmptyString]
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMonitoringDetails
  ) extends zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.ReadOnly {
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMonitoringDetails
  ): zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.ReadOnly =
    new Wrapper(impl)
}
