package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableReplicaGlobalSecondaryIndex(
    indexName: Optional[NonEmptyString] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex = {
    import AwsDynamoDbTableReplicaGlobalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
      .builder()
      .optionallyWith(
        indexName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableReplicaGlobalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex =
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex(
        indexName.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable)
      )
    def indexName: Optional[NonEmptyString]
    def provisionedThroughputOverride: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ]
    def getIndexName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly {
    override val indexName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val provisionedThroughputOverride: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
  ): zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly =
    new Wrapper(impl)
}
