package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDmsReplicationInstanceVpcSecurityGroupsDetails(
    vpcSecurityGroupId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails = {
    import AwsDmsReplicationInstanceVpcSecurityGroupsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
      .builder()
      .optionallyWith(
        vpcSecurityGroupId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcSecurityGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
      .wrap(buildAwsValue())
}
object AwsDmsReplicationInstanceVpcSecurityGroupsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails =
      zio.aws.securityhub.model
        .AwsDmsReplicationInstanceVpcSecurityGroupsDetails(
          vpcSecurityGroupId.map(value => value)
        )
    def vpcSecurityGroupId: Optional[NonEmptyString]
    def getVpcSecurityGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
  ) extends zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.ReadOnly {
    override val vpcSecurityGroupId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
  ): zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.ReadOnly =
    new Wrapper(impl)
}
