package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDmsReplicationInstanceDetails(
    allocatedStorage: Optional[Integer] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    preferredMaintenanceWindow: Optional[NonEmptyString] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    replicationInstanceClass: Optional[NonEmptyString] = Optional.Absent,
    replicationInstanceIdentifier: Optional[NonEmptyString] = Optional.Absent,
    replicationSubnetGroup: Optional[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
    ] = Optional.Absent,
    vpcSecurityGroups: Optional[Iterable[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceDetails = {
    import AwsDmsReplicationInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceDetails
      .builder()
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        replicationInstanceClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicationInstanceClass)
      .optionallyWith(
        replicationInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicationInstanceIdentifier)
      .optionallyWith(
        replicationSubnetGroup.map(value => value.buildAwsValue())
      )(_.replicationSubnetGroup)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDmsReplicationInstanceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDmsReplicationInstanceDetails
      .wrap(buildAwsValue())
}
object AwsDmsReplicationInstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDmsReplicationInstanceDetails =
      zio.aws.securityhub.model.AwsDmsReplicationInstanceDetails(
        allocatedStorage.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        availabilityZone.map(value => value),
        engineVersion.map(value => value),
        kmsKeyId.map(value => value),
        multiAZ.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        replicationInstanceClass.map(value => value),
        replicationInstanceIdentifier.map(value => value),
        replicationSubnetGroup.map(value => value.asEditable),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allocatedStorage: Optional[Integer]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def availabilityZone: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def kmsKeyId: Optional[NonEmptyString]
    def multiAZ: Optional[Boolean]
    def preferredMaintenanceWindow: Optional[NonEmptyString]
    def publiclyAccessible: Optional[Boolean]
    def replicationInstanceClass: Optional[NonEmptyString]
    def replicationInstanceIdentifier: Optional[NonEmptyString]
    def replicationSubnetGroup: Optional[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.ReadOnly
    ]
    def vpcSecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.ReadOnly
    ]]
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getReplicationInstanceClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "replicationInstanceClass",
        replicationInstanceClass
      )
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
    def getReplicationSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationSubnetGroup",
      replicationSubnetGroup
    )
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceDetails
  ) extends zio.aws.securityhub.model.AwsDmsReplicationInstanceDetails.ReadOnly {
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val preferredMaintenanceWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val replicationInstanceClass: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceClass())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val replicationInstanceIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val replicationSubnetGroup: Optional[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationSubnetGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
          .wrap(value)
      )
    override val vpcSecurityGroups: Optional[List[
      zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceDetails
  ): zio.aws.securityhub.model.AwsDmsReplicationInstanceDetails.ReadOnly =
    new Wrapper(impl)
}
