package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDmsEndpointDetails(
    certificateArn: Optional[NonEmptyString] = Optional.Absent,
    databaseName: Optional[NonEmptyString] = Optional.Absent,
    endpointArn: Optional[NonEmptyString] = Optional.Absent,
    endpointIdentifier: Optional[NonEmptyString] = Optional.Absent,
    endpointType: Optional[NonEmptyString] = Optional.Absent,
    engineName: Optional[NonEmptyString] = Optional.Absent,
    externalId: Optional[NonEmptyString] = Optional.Absent,
    extraConnectionAttributes: Optional[NonEmptyString] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    serverName: Optional[NonEmptyString] = Optional.Absent,
    sslMode: Optional[NonEmptyString] = Optional.Absent,
    username: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDmsEndpointDetails = {
    import AwsDmsEndpointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDmsEndpointDetails
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        databaseName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        endpointArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpointArn)
      .optionallyWith(
        endpointIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.endpointIdentifier)
      .optionallyWith(
        endpointType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.endpointType)
      .optionallyWith(
        engineName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engineName)
      .optionallyWith(
        externalId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        extraConnectionAttributes.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.extraConnectionAttributes)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        serverName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serverName)
      .optionallyWith(
        sslMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sslMode)
      .optionallyWith(
        username.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsDmsEndpointDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDmsEndpointDetails.wrap(buildAwsValue())
}
object AwsDmsEndpointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDmsEndpointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDmsEndpointDetails =
      zio.aws.securityhub.model.AwsDmsEndpointDetails(
        certificateArn.map(value => value),
        databaseName.map(value => value),
        endpointArn.map(value => value),
        endpointIdentifier.map(value => value),
        endpointType.map(value => value),
        engineName.map(value => value),
        externalId.map(value => value),
        extraConnectionAttributes.map(value => value),
        kmsKeyId.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        sslMode.map(value => value),
        username.map(value => value)
      )
    def certificateArn: Optional[NonEmptyString]
    def databaseName: Optional[NonEmptyString]
    def endpointArn: Optional[NonEmptyString]
    def endpointIdentifier: Optional[NonEmptyString]
    def endpointType: Optional[NonEmptyString]
    def engineName: Optional[NonEmptyString]
    def externalId: Optional[NonEmptyString]
    def extraConnectionAttributes: Optional[NonEmptyString]
    def kmsKeyId: Optional[NonEmptyString]
    def port: Optional[Integer]
    def serverName: Optional[NonEmptyString]
    def sslMode: Optional[NonEmptyString]
    def username: Optional[NonEmptyString]
    def getCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getDatabaseName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getEndpointArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getEndpointIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointIdentifier", endpointIdentifier)
    def getEndpointType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getEngineName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getExternalId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getExtraConnectionAttributes: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "extraConnectionAttributes",
        extraConnectionAttributes
      )
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getSslMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sslMode", sslMode)
    def getUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsEndpointDetails
  ) extends zio.aws.securityhub.model.AwsDmsEndpointDetails.ReadOnly {
    override val certificateArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val databaseName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val endpointType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val externalId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val extraConnectionAttributes: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extraConnectionAttributes())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val serverName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sslMode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sslMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val username: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDmsEndpointDetails
  ): zio.aws.securityhub.model.AwsDmsEndpointDetails.ReadOnly = new Wrapper(
    impl
  )
}
