package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginCustomOriginConfig(
    httpPort: Optional[Integer] = Optional.Absent,
    httpsPort: Optional[Integer] = Optional.Absent,
    originKeepaliveTimeout: Optional[Integer] = Optional.Absent,
    originProtocolPolicy: Optional[NonEmptyString] = Optional.Absent,
    originReadTimeout: Optional[Integer] = Optional.Absent,
    originSslProtocols: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig = {
    import AwsCloudFrontDistributionOriginCustomOriginConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig
      .builder()
      .optionallyWith(httpPort.map(value => value: java.lang.Integer))(
        _.httpPort
      )
      .optionallyWith(httpsPort.map(value => value: java.lang.Integer))(
        _.httpsPort
      )
      .optionallyWith(
        originKeepaliveTimeout.map(value => value: java.lang.Integer)
      )(_.originKeepaliveTimeout)
      .optionallyWith(
        originProtocolPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originProtocolPolicy)
      .optionallyWith(originReadTimeout.map(value => value: java.lang.Integer))(
        _.originReadTimeout
      )
      .optionallyWith(originSslProtocols.map(value => value.buildAwsValue()))(
        _.originSslProtocols
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginCustomOriginConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig =
      zio.aws.securityhub.model
        .AwsCloudFrontDistributionOriginCustomOriginConfig(
          httpPort.map(value => value),
          httpsPort.map(value => value),
          originKeepaliveTimeout.map(value => value),
          originProtocolPolicy.map(value => value),
          originReadTimeout.map(value => value),
          originSslProtocols.map(value => value.asEditable)
        )
    def httpPort: Optional[Integer]
    def httpsPort: Optional[Integer]
    def originKeepaliveTimeout: Optional[Integer]
    def originProtocolPolicy: Optional[NonEmptyString]
    def originReadTimeout: Optional[Integer]
    def originSslProtocols: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.ReadOnly
    ]
    def getHttpPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("httpPort", httpPort)
    def getHttpsPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("httpsPort", httpsPort)
    def getOriginKeepaliveTimeout: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("originKeepaliveTimeout", originKeepaliveTimeout)
    def getOriginProtocolPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originProtocolPolicy", originProtocolPolicy)
    def getOriginReadTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originReadTimeout", originReadTimeout)
    def getOriginSslProtocols: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.ReadOnly
    ] = AwsError.unwrapOptionField("originSslProtocols", originSslProtocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig.ReadOnly {
    override val httpPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.httpPort())
      .map(value => value: Integer)
    override val httpsPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.httpsPort())
      .map(value => value: Integer)
    override val originKeepaliveTimeout: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originKeepaliveTimeout())
        .map(value => value: Integer)
    override val originProtocolPolicy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originProtocolPolicy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val originReadTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.originReadTimeout())
      .map(value => value: Integer)
    override val originSslProtocols: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originSslProtocols())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig.ReadOnly =
    new Wrapper(impl)
}
