package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionDefaultCacheBehavior(
    viewerProtocolPolicy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior = {
    import AwsCloudFrontDistributionDefaultCacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
      .builder()
      .optionallyWith(
        viewerProtocolPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.viewerProtocolPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionDefaultCacheBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior =
      zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior(
        viewerProtocolPolicy.map(value => value)
      )
    def viewerProtocolPolicy: Optional[NonEmptyString]
    def getViewerProtocolPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("viewerProtocolPolicy", viewerProtocolPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior.ReadOnly {
    override val viewerProtocolPolicy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewerProtocolPolicy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior.ReadOnly =
    new Wrapper(impl)
}
