package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails(
    encryptionOption: Optional[NonEmptyString] = Optional.Absent,
    kmsKey: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails = {
    import AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
      .builder()
      .optionallyWith(
        encryptionOption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionOption)
      .optionallyWith(
        kmsKey.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails =
      zio.aws.securityhub.model
        .AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails(
          encryptionOption.map(value => value),
          kmsKey.map(value => value)
        )
    def encryptionOption: Optional[NonEmptyString]
    def kmsKey: Optional[NonEmptyString]
    def getEncryptionOption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionOption", encryptionOption)
    def getKmsKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.ReadOnly {
    override val encryptionOption: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionOption())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val kmsKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
  ): zio.aws.securityhub.model.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
