package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAppSyncGraphQlApiUserPoolConfigDetails(
    appIdClientRegex: Optional[NonEmptyString] = Optional.Absent,
    awsRegion: Optional[NonEmptyString] = Optional.Absent,
    defaultAction: Optional[NonEmptyString] = Optional.Absent,
    userPoolId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails = {
    import AwsAppSyncGraphQlApiUserPoolConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
      .builder()
      .optionallyWith(
        appIdClientRegex.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.appIdClientRegex)
      .optionallyWith(
        awsRegion.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(
        defaultAction.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultAction)
      .optionallyWith(
        userPoolId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
      .wrap(buildAwsValue())
}
object AwsAppSyncGraphQlApiUserPoolConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails =
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails(
        appIdClientRegex.map(value => value),
        awsRegion.map(value => value),
        defaultAction.map(value => value),
        userPoolId.map(value => value)
      )
    def appIdClientRegex: Optional[NonEmptyString]
    def awsRegion: Optional[NonEmptyString]
    def defaultAction: Optional[NonEmptyString]
    def userPoolId: Optional[NonEmptyString]
    def getAppIdClientRegex: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("appIdClientRegex", appIdClientRegex)
    def getAwsRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getDefaultAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultAction", defaultAction)
    def getUserPoolId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
  ) extends zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly {
    override val appIdClientRegex: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appIdClientRegex())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val awsRegion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultAction: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultAction())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userPoolId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
  ): zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly =
    new Wrapper(impl)
}
