package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAppSyncGraphQlApiLogConfigDetails(
    cloudWatchLogsRoleArn: Optional[NonEmptyString] = Optional.Absent,
    excludeVerboseContent: Optional[Boolean] = Optional.Absent,
    fieldLogLevel: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails = {
    import AwsAppSyncGraphQlApiLogConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsRoleArn)
      .optionallyWith(
        excludeVerboseContent.map(value => value: java.lang.Boolean)
      )(_.excludeVerboseContent)
      .optionallyWith(
        fieldLogLevel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fieldLogLevel)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
      .wrap(buildAwsValue())
}
object AwsAppSyncGraphQlApiLogConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails =
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails(
        cloudWatchLogsRoleArn.map(value => value),
        excludeVerboseContent.map(value => value),
        fieldLogLevel.map(value => value)
      )
    def cloudWatchLogsRoleArn: Optional[NonEmptyString]
    def excludeVerboseContent: Optional[Boolean]
    def fieldLogLevel: Optional[NonEmptyString]
    def getCloudWatchLogsRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cloudWatchLogsRoleArn", cloudWatchLogsRoleArn)
    def getExcludeVerboseContent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excludeVerboseContent", excludeVerboseContent)
    def getFieldLogLevel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fieldLogLevel", fieldLogLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
  ) extends zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails.ReadOnly {
    override val cloudWatchLogsRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val excludeVerboseContent: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeVerboseContent())
        .map(value => value: Boolean)
    override val fieldLogLevel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLogLevel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
  ): zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails.ReadOnly =
    new Wrapper(impl)
}
