package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(
    authorizerResultTtlInSeconds: Optional[Integer] = Optional.Absent,
    authorizerUri: Optional[NonEmptyString] = Optional.Absent,
    identityValidationExpression: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails = {
    import AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
      .builder()
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value => value: java.lang.Integer)
      )(_.authorizerResultTtlInSeconds)
      .optionallyWith(
        authorizerUri.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.authorizerUri)
      .optionallyWith(
        identityValidationExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.identityValidationExpression)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
      .wrap(buildAwsValue())
}
object AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails =
      zio.aws.securityhub.model
        .AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(
          authorizerResultTtlInSeconds.map(value => value),
          authorizerUri.map(value => value),
          identityValidationExpression.map(value => value)
        )
    def authorizerResultTtlInSeconds: Optional[Integer]
    def authorizerUri: Optional[NonEmptyString]
    def identityValidationExpression: Optional[NonEmptyString]
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
    def getAuthorizerUri: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getIdentityValidationExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
  ) extends zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly {
    override val authorizerResultTtlInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerResultTtlInSeconds())
        .map(value => value: Integer)
    override val authorizerUri: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerUri())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val identityValidationExpression: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityValidationExpression())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
  ): zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly =
    new Wrapper(impl)
}
