package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAppSyncGraphQlApiDetails(
    apiId: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    openIdConnectConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    lambdaAuthorizerConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
    ] = Optional.Absent,
    xrayEnabled: Optional[Boolean] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    userPoolConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
    ] = Optional.Absent,
    authenticationType: Optional[NonEmptyString] = Optional.Absent,
    logConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
    ] = Optional.Absent,
    additionalAuthenticationProviders: Optional[Iterable[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
    ]] = Optional.Absent,
    wafWebAclArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiDetails = {
    import AwsAppSyncGraphQlApiDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiDetails
      .builder()
      .optionallyWith(
        apiId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.apiId)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(openIdConnectConfig.map(value => value.buildAwsValue()))(
        _.openIdConnectConfig
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(
        authenticationType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.authenticationType)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(
        wafWebAclArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.wafWebAclArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAppSyncGraphQlApiDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiDetails.wrap(buildAwsValue())
}
object AwsAppSyncGraphQlApiDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsAppSyncGraphQlApiDetails =
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiDetails(
        apiId.map(value => value),
        id.map(value => value),
        openIdConnectConfig.map(value => value.asEditable),
        name.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable),
        xrayEnabled.map(value => value),
        arn.map(value => value),
        userPoolConfig.map(value => value.asEditable),
        authenticationType.map(value => value),
        logConfig.map(value => value.asEditable),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wafWebAclArn.map(value => value)
      )
    def apiId: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def openIdConnectConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly
    ]
    def name: Optional[NonEmptyString]
    def lambdaAuthorizerConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly
    ]
    def xrayEnabled: Optional[Boolean]
    def arn: Optional[NonEmptyString]
    def userPoolConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly
    ]
    def authenticationType: Optional[NonEmptyString]
    def logConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails.ReadOnly
    ]
    def additionalAuthenticationProviders: Optional[List[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.ReadOnly
    ]]
    def wafWebAclArn: Optional[NonEmptyString]
    def getApiId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getOpenIdConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("openIdConnectConfig", openIdConnectConfig)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getUserPoolConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getAuthenticationType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logConfig", logConfig)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getWafWebAclArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("wafWebAclArn", wafWebAclArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiDetails
  ) extends zio.aws.securityhub.model.AwsAppSyncGraphQlApiDetails.ReadOnly {
    override val apiId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.apiId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val openIdConnectConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openIdConnectConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
          .wrap(value)
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lambdaAuthorizerConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaAuthorizerConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
          .wrap(value)
      )
    override val xrayEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.xrayEnabled())
      .map(value => value: Boolean)
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userPoolConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
          .wrap(value)
      )
    override val authenticationType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val logConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails
          .wrap(value)
      )
    override val additionalAuthenticationProviders: Optional[List[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
            .wrap(item)
        }.toList
      )
    override val wafWebAclArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.wafWebAclArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiDetails
  ): zio.aws.securityhub.model.AwsAppSyncGraphQlApiDetails.ReadOnly =
    new Wrapper(impl)
}
