package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayMethodSettings(
    metricsEnabled: Optional[Boolean] = Optional.Absent,
    loggingLevel: Optional[NonEmptyString] = Optional.Absent,
    dataTraceEnabled: Optional[Boolean] = Optional.Absent,
    throttlingBurstLimit: Optional[Integer] = Optional.Absent,
    throttlingRateLimit: Optional[Double] = Optional.Absent,
    cachingEnabled: Optional[Boolean] = Optional.Absent,
    cacheTtlInSeconds: Optional[Integer] = Optional.Absent,
    cacheDataEncrypted: Optional[Boolean] = Optional.Absent,
    requireAuthorizationForCacheControl: Optional[Boolean] = Optional.Absent,
    unauthorizedCacheControlHeaderStrategy: Optional[NonEmptyString] =
      Optional.Absent,
    httpMethod: Optional[NonEmptyString] = Optional.Absent,
    resourcePath: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings = {
    import AwsApiGatewayMethodSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
      .builder()
      .optionallyWith(metricsEnabled.map(value => value: java.lang.Boolean))(
        _.metricsEnabled
      )
      .optionallyWith(
        loggingLevel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loggingLevel)
      .optionallyWith(dataTraceEnabled.map(value => value: java.lang.Boolean))(
        _.dataTraceEnabled
      )
      .optionallyWith(
        throttlingBurstLimit.map(value => value: java.lang.Integer)
      )(_.throttlingBurstLimit)
      .optionallyWith(
        throttlingRateLimit.map(value => value: java.lang.Double)
      )(_.throttlingRateLimit)
      .optionallyWith(cachingEnabled.map(value => value: java.lang.Boolean))(
        _.cachingEnabled
      )
      .optionallyWith(cacheTtlInSeconds.map(value => value: java.lang.Integer))(
        _.cacheTtlInSeconds
      )
      .optionallyWith(
        cacheDataEncrypted.map(value => value: java.lang.Boolean)
      )(_.cacheDataEncrypted)
      .optionallyWith(
        requireAuthorizationForCacheControl.map(value =>
          value: java.lang.Boolean
        )
      )(_.requireAuthorizationForCacheControl)
      .optionallyWith(
        unauthorizedCacheControlHeaderStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.unauthorizedCacheControlHeaderStrategy)
      .optionallyWith(
        httpMethod.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.httpMethod)
      .optionallyWith(
        resourcePath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourcePath)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayMethodSettings.wrap(buildAwsValue())
}
object AwsApiGatewayMethodSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayMethodSettings =
      zio.aws.securityhub.model.AwsApiGatewayMethodSettings(
        metricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        dataTraceEnabled.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value),
        cachingEnabled.map(value => value),
        cacheTtlInSeconds.map(value => value),
        cacheDataEncrypted.map(value => value),
        requireAuthorizationForCacheControl.map(value => value),
        unauthorizedCacheControlHeaderStrategy.map(value => value),
        httpMethod.map(value => value),
        resourcePath.map(value => value)
      )
    def metricsEnabled: Optional[Boolean]
    def loggingLevel: Optional[NonEmptyString]
    def dataTraceEnabled: Optional[Boolean]
    def throttlingBurstLimit: Optional[Integer]
    def throttlingRateLimit: Optional[Double]
    def cachingEnabled: Optional[Boolean]
    def cacheTtlInSeconds: Optional[Integer]
    def cacheDataEncrypted: Optional[Boolean]
    def requireAuthorizationForCacheControl: Optional[Boolean]
    def unauthorizedCacheControlHeaderStrategy: Optional[NonEmptyString]
    def httpMethod: Optional[NonEmptyString]
    def resourcePath: Optional[NonEmptyString]
    def getMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("metricsEnabled", metricsEnabled)
    def getLoggingLevel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getDataTraceEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
    def getCachingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cachingEnabled", cachingEnabled)
    def getCacheTtlInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cacheTtlInSeconds", cacheTtlInSeconds)
    def getCacheDataEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheDataEncrypted", cacheDataEncrypted)
    def getRequireAuthorizationForCacheControl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "requireAuthorizationForCacheControl",
        requireAuthorizationForCacheControl
      )
    def getUnauthorizedCacheControlHeaderStrategy
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "unauthorizedCacheControlHeaderStrategy",
      unauthorizedCacheControlHeaderStrategy
    )
    def getHttpMethod: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getResourcePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourcePath", resourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
  ) extends zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly {
    override val metricsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.metricsEnabled())
      .map(value => value: Boolean)
    override val loggingLevel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingLevel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dataTraceEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataTraceEnabled())
      .map(value => value: Boolean)
    override val throttlingBurstLimit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.throttlingBurstLimit())
      .map(value => value: Integer)
    override val throttlingRateLimit: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.throttlingRateLimit())
      .map(value => value: Double)
    override val cachingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cachingEnabled())
      .map(value => value: Boolean)
    override val cacheTtlInSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheTtlInSeconds())
      .map(value => value: Integer)
    override val cacheDataEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheDataEncrypted())
      .map(value => value: Boolean)
    override val requireAuthorizationForCacheControl: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireAuthorizationForCacheControl())
        .map(value => value: Boolean)
    override val unauthorizedCacheControlHeaderStrategy
        : Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.unauthorizedCacheControlHeaderStrategy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpMethod: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpMethod())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourcePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
  ): zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly =
    new Wrapper(impl)
}
