package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails(
    dayOfWeek: Optional[NonEmptyString] = Optional.Absent,
    timeOfDay: Optional[NonEmptyString] = Optional.Absent,
    timeZone: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails = {
    import AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
      .builder()
      .optionallyWith(
        dayOfWeek.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dayOfWeek)
      .optionallyWith(
        timeOfDay.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.timeOfDay)
      .optionallyWith(
        timeZone.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.timeZone)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
      .wrap(buildAwsValue())
}
object AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails =
      zio.aws.securityhub.model
        .AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails(
          dayOfWeek.map(value => value),
          timeOfDay.map(value => value),
          timeZone.map(value => value)
        )
    def dayOfWeek: Optional[NonEmptyString]
    def timeOfDay: Optional[NonEmptyString]
    def timeZone: Optional[NonEmptyString]
    def getDayOfWeek: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getTimeOfDay: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("timeOfDay", timeOfDay)
    def getTimeZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("timeZone", timeZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.ReadOnly {
    override val dayOfWeek: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfWeek())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timeOfDay: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.timeOfDay())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timeZone: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.timeZone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.ReadOnly =
    new Wrapper(impl)
}
