package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerLdapServerMetadataDetails(
    hosts: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    roleBase: Optional[NonEmptyString] = Optional.Absent,
    roleName: Optional[NonEmptyString] = Optional.Absent,
    roleSearchMatching: Optional[NonEmptyString] = Optional.Absent,
    roleSearchSubtree: Optional[Boolean] = Optional.Absent,
    serviceAccountUsername: Optional[NonEmptyString] = Optional.Absent,
    userBase: Optional[NonEmptyString] = Optional.Absent,
    userRoleName: Optional[NonEmptyString] = Optional.Absent,
    userSearchMatching: Optional[NonEmptyString] = Optional.Absent,
    userSearchSubtree: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails = {
    import AwsAmazonMqBrokerLdapServerMetadataDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
      .builder()
      .optionallyWith(
        hosts.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hosts)
      .optionallyWith(
        roleBase.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleBase)
      .optionallyWith(
        roleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        roleSearchMatching.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.roleSearchMatching)
      .optionallyWith(roleSearchSubtree.map(value => value: java.lang.Boolean))(
        _.roleSearchSubtree
      )
      .optionallyWith(
        serviceAccountUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.serviceAccountUsername)
      .optionallyWith(
        userBase.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userBase)
      .optionallyWith(
        userRoleName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.userRoleName)
      .optionallyWith(
        userSearchMatching.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.userSearchMatching)
      .optionallyWith(userSearchSubtree.map(value => value: java.lang.Boolean))(
        _.userSearchSubtree
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
      .wrap(buildAwsValue())
}
object AwsAmazonMqBrokerLdapServerMetadataDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails =
      zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails(
        hosts.map(value => value),
        roleBase.map(value => value),
        roleName.map(value => value),
        roleSearchMatching.map(value => value),
        roleSearchSubtree.map(value => value),
        serviceAccountUsername.map(value => value),
        userBase.map(value => value),
        userRoleName.map(value => value),
        userSearchMatching.map(value => value),
        userSearchSubtree.map(value => value)
      )
    def hosts: Optional[List[NonEmptyString]]
    def roleBase: Optional[NonEmptyString]
    def roleName: Optional[NonEmptyString]
    def roleSearchMatching: Optional[NonEmptyString]
    def roleSearchSubtree: Optional[Boolean]
    def serviceAccountUsername: Optional[NonEmptyString]
    def userBase: Optional[NonEmptyString]
    def userRoleName: Optional[NonEmptyString]
    def userSearchMatching: Optional[NonEmptyString]
    def userSearchSubtree: Optional[Boolean]
    def getHosts: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("hosts", hosts)
    def getRoleBase: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleBase", roleBase)
    def getRoleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getRoleSearchMatching: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleSearchMatching", roleSearchMatching)
    def getRoleSearchSubtree: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("roleSearchSubtree", roleSearchSubtree)
    def getServiceAccountUsername: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("serviceAccountUsername", serviceAccountUsername)
    def getUserBase: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userBase", userBase)
    def getUserRoleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userRoleName", userRoleName)
    def getUserSearchMatching: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userSearchMatching", userSearchMatching)
    def getUserSearchSubtree: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("userSearchSubtree", userSearchSubtree)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.ReadOnly {
    override val hosts: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.hosts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val roleBase: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleBase())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleSearchMatching: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleSearchMatching())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val roleSearchSubtree: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.roleSearchSubtree())
      .map(value => value: Boolean)
    override val serviceAccountUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceAccountUsername())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val userBase: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userBase())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userRoleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userRoleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userSearchMatching: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userSearchMatching())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val userSearchSubtree: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.userSearchSubtree())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.ReadOnly =
    new Wrapper(impl)
}
