package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerEncryptionOptionsDetails(
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    useAwsOwnedKey: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails = {
    import AwsAmazonMqBrokerEncryptionOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(useAwsOwnedKey.map(value => value: java.lang.Boolean))(
        _.useAwsOwnedKey
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
      .wrap(buildAwsValue())
}
object AwsAmazonMqBrokerEncryptionOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails =
      zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails(
        kmsKeyId.map(value => value),
        useAwsOwnedKey.map(value => value)
      )
    def kmsKeyId: Optional[NonEmptyString]
    def useAwsOwnedKey: Optional[Boolean]
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getUseAwsOwnedKey: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useAwsOwnedKey", useAwsOwnedKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.ReadOnly {
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val useAwsOwnedKey: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useAwsOwnedKey())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
