package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait AutomationRulesActionType {
  def unwrap: software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType
}
object AutomationRulesActionType {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType
  ): zio.aws.securityhub.model.AutomationRulesActionType = value match {
    case software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType.FINDING_FIELDS_UPDATE =>
      val r = FINDING_FIELDS_UPDATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.AutomationRulesActionType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType =
      software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object FINDING_FIELDS_UPDATE
      extends zio.aws.securityhub.model.AutomationRulesActionType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType =
      software.amazon.awssdk.services.securityhub.model.AutomationRulesActionType.FINDING_FIELDS_UPDATE
  }
}
