package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionRemotePortDetails(
    port: Optional[Integer] = Optional.Absent,
    portName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionRemotePortDetails = {
    import ActionRemotePortDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionRemotePortDetails
      .builder()
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        portName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.portName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionRemotePortDetails.ReadOnly =
    zio.aws.securityhub.model.ActionRemotePortDetails.wrap(buildAwsValue())
}
object ActionRemotePortDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionRemotePortDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionRemotePortDetails =
      zio.aws.securityhub.model.ActionRemotePortDetails(
        port.map(value => value),
        portName.map(value => value)
      )
    def port: Optional[Integer]
    def portName: Optional[NonEmptyString]
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPortName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("portName", portName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionRemotePortDetails
  ) extends zio.aws.securityhub.model.ActionRemotePortDetails.ReadOnly {
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val portName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.portName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionRemotePortDetails
  ): zio.aws.securityhub.model.ActionRemotePortDetails.ReadOnly = new Wrapper(
    impl
  )
}
