package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionLocalPortDetails(
    port: Optional[Integer] = Optional.Absent,
    portName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails = {
    import ActionLocalPortDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
      .builder()
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        portName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.portName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly =
    zio.aws.securityhub.model.ActionLocalPortDetails.wrap(buildAwsValue())
}
object ActionLocalPortDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionLocalPortDetails =
      zio.aws.securityhub.model.ActionLocalPortDetails(
        port.map(value => value),
        portName.map(value => value)
      )
    def port: Optional[Integer]
    def portName: Optional[NonEmptyString]
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPortName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("portName", portName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
  ) extends zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly {
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val portName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.portName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
  ): zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly = new Wrapper(
    impl
  )
}
