package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Standard(
    standardsArn: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    enabledByDefault: Optional[Boolean] = Optional.Absent,
    standardsManagedBy: Optional[zio.aws.securityhub.model.StandardsManagedBy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Standard = {
    import Standard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Standard
      .builder()
      .optionallyWith(
        standardsArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsArn)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(enabledByDefault.map(value => value: java.lang.Boolean))(
        _.enabledByDefault
      )
      .optionallyWith(standardsManagedBy.map(value => value.buildAwsValue()))(
        _.standardsManagedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Standard.ReadOnly =
    zio.aws.securityhub.model.Standard.wrap(buildAwsValue())
}
object Standard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Standard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Standard =
      zio.aws.securityhub.model.Standard(
        standardsArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        enabledByDefault.map(value => value),
        standardsManagedBy.map(value => value.asEditable)
      )
    def standardsArn: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def enabledByDefault: Optional[Boolean]
    def standardsManagedBy
        : Optional[zio.aws.securityhub.model.StandardsManagedBy.ReadOnly]
    def getStandardsArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsArn", standardsArn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEnabledByDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabledByDefault", enabledByDefault)
    def getStandardsManagedBy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.StandardsManagedBy.ReadOnly
    ] = AwsError.unwrapOptionField("standardsManagedBy", standardsManagedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Standard
  ) extends zio.aws.securityhub.model.Standard.ReadOnly {
    override val standardsArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.standardsArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabledByDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabledByDefault())
      .map(value => value: Boolean)
    override val standardsManagedBy
        : Optional[zio.aws.securityhub.model.StandardsManagedBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardsManagedBy())
        .map(value => zio.aws.securityhub.model.StandardsManagedBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Standard
  ): zio.aws.securityhub.model.Standard.ReadOnly = new Wrapper(impl)
}
