package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkPathComponentDetails(
    address: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    portRanges: Optional[Iterable[zio.aws.securityhub.model.PortRange]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NetworkPathComponentDetails = {
    import NetworkPathComponentDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NetworkPathComponentDetails
      .builder()
      .optionallyWith(
        address.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.address)
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly =
    zio.aws.securityhub.model.NetworkPathComponentDetails.wrap(buildAwsValue())
}
object NetworkPathComponentDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NetworkPathComponentDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NetworkPathComponentDetails =
      zio.aws.securityhub.model.NetworkPathComponentDetails(
        address.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def address: Optional[List[NonEmptyString]]
    def portRanges: Optional[List[zio.aws.securityhub.model.PortRange.ReadOnly]]
    def getAddress: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("address", address)
    def getPortRanges: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("portRanges", portRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkPathComponentDetails
  ) extends zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly {
    override val address: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val portRanges
        : Optional[List[zio.aws.securityhub.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.PortRange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkPathComponentDetails
  ): zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly =
    new Wrapper(impl)
}
