package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMembersResponse(
    unprocessedAccounts: Optional[Iterable[zio.aws.securityhub.model.Result]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateMembersResponse = {
    import CreateMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateMembersResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.CreateMembersResponse.ReadOnly =
    zio.aws.securityhub.model.CreateMembersResponse.wrap(buildAwsValue())
}
object CreateMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateMembersResponse =
      zio.aws.securityhub.model.CreateMembersResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]]
    def getUnprocessedAccounts
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Result.ReadOnly]] =
      AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateMembersResponse
  ) extends zio.aws.securityhub.model.CreateMembersResponse.ReadOnly {
    override val unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Result.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateMembersResponse
  ): zio.aws.securityhub.model.CreateMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
