package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails(
    immunityTime: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails = {
    import AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
      .builder()
      .optionallyWith(immunityTime.map(value => value: java.lang.Long))(
        _.immunityTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
      .wrap(buildAwsValue())
}
object AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails =
      zio.aws.securityhub.model
        .AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails(
          immunityTime.map(value => value)
        )
    def immunityTime: Optional[Long]
    def getImmunityTime: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("immunityTime", immunityTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
  ) extends zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.ReadOnly {
    override val immunityTime: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.immunityTime())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
  ): zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.ReadOnly =
    new Wrapper(impl)
}
