package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2WebAclActionDetails(
    allow: Optional[zio.aws.securityhub.model.AwsWafv2ActionAllowDetails] =
      Optional.Absent,
    block: Optional[zio.aws.securityhub.model.AwsWafv2ActionBlockDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclActionDetails = {
    import AwsWafv2WebAclActionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclActionDetails
      .builder()
      .optionallyWith(allow.map(value => value.buildAwsValue()))(_.allow)
      .optionallyWith(block.map(value => value.buildAwsValue()))(_.block)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.wrap(buildAwsValue())
}
object AwsWafv2WebAclActionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclActionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2WebAclActionDetails =
      zio.aws.securityhub.model.AwsWafv2WebAclActionDetails(
        allow.map(value => value.asEditable),
        block.map(value => value.asEditable)
      )
    def allow: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly
    ]
    def block: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly
    ]
    def getAllow: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly
    ] = AwsError.unwrapOptionField("allow", allow)
    def getBlock: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly
    ] = AwsError.unwrapOptionField("block", block)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclActionDetails
  ) extends zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.ReadOnly {
    override val allow: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.allow())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2ActionAllowDetails.wrap(value)
      )
    override val block: Optional[
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.block())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclActionDetails
  ): zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.ReadOnly =
    new Wrapper(impl)
}
