package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsStepFunctionStateMachineLoggingConfigurationDetails(
    destinations: Optional[Iterable[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
    ]] = Optional.Absent,
    includeExecutionData: Optional[Boolean] = Optional.Absent,
    level: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails = {
    import AwsStepFunctionStateMachineLoggingConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
      .builder()
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        includeExecutionData.map(value => value: java.lang.Boolean)
      )(_.includeExecutionData)
      .optionallyWith(
        level.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.level)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsStepFunctionStateMachineLoggingConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails =
      zio.aws.securityhub.model
        .AwsStepFunctionStateMachineLoggingConfigurationDetails(
          destinations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          includeExecutionData.map(value => value),
          level.map(value => value)
        )
    def destinations: Optional[List[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.ReadOnly
    ]]
    def includeExecutionData: Optional[Boolean]
    def level: Optional[NonEmptyString]
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getIncludeExecutionData: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeExecutionData", includeExecutionData)
    def getLevel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("level", level)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails.ReadOnly {
    override val destinations: Optional[List[
      zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
            .wrap(item)
        }.toList
      )
    override val includeExecutionData: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeExecutionData())
      .map(value => value: Boolean)
    override val level: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.level())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails
  ): zio.aws.securityhub.model.AwsStepFunctionStateMachineLoggingConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
