package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails(
    key: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
      .builder()
      .optionallyWith(
        key.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails(
          key.map(value => value),
          value.map(value => value)
        )
    def key: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly {
    override val key: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly =
    new Wrapper(impl)
}
